library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 
  

entity tm_tb is
end entity tm_tb;

architecture arch of tm_tb is
	signal clk_tb:std_logic:='0';
        signal start_tb:std_logic;
        signal pdm_data_tb:std_logic_vector(3 downto 0);
        signal pdm_data_mux_tb:std_logic_vector(7 downto 0);
        signal data_tvalid_tb:std_logic;
        signal data_tlast_tb:std_logic; 

		component timemux is 
		port( 
			clk:in std_logic;
                        start:in std_logic;
      			pdm_data:in std_logic_vector(3 downto 0);
	  		pdm_data_mux:out std_logic_vector(7 downto 0);
                        data_tvalid:out std_logic;
                        data_tlast:out std_logic);
                    
		end component timemux;

begin 
		timemux1_component:
		component timemux
			port map( 
			clk=>clk_tb,
                        start=>start_tb,
 	     		pdm_data=>pdm_data_tb,
                        pdm_data_mux=>pdm_data_mux_tb,
                        data_tvalid=>data_tvalid_tb,
                        data_tlast=>data_tlast_tb);
		

  	clkproc:
		process
			begin
			Wait for 50 ns;
			clk_tb<=not(clk_tb);
		end process; 
                
                start_tb<='0',
                          '1' after 100 ns;
		pdm_data_tb<= "0000",
			      "0001" after 500 ns,
			      "0010" after 1000 ns;

    test_proc:
		process
			begin
			wait for 50 ns;
			assert( pdm_data_mux_tb= "00000000")
			report "incorrect result"
			severity error;
			
                        assert( data_tvalid_tb= '0')
			report "incorrect result"
			severity error;

                        assert( data_tlast_tb='0')
			report "incorrect result"
			severity error;



			wait for 450 ns; --500 ns
			assert( pdm_data_mux_tb= "00000000")
			report "incorrect result"
			severity error;

                        assert( data_tvalid_tb= '0')
			report "incorrect result"
			severity error;

                        assert( data_tlast_tb= '0')
			report "incorrect result"
			severity error;

			wait for 500 ns; -- 1000 ns
			assert( pdm_data_mux_tb= "00000000")
			report "incorrect result"
			severity error;

                        assert( data_tvalid_tb= '0')
			report "incorrect result"
			severity error;

                        assert( data_tlast_tb= '0')
			report "incorrect result"
			severity error;
		end process;
end architecture arch;
			
			
			
			
